package org.sc3d.apt.jrider.v1;

/** Represents the state of an algorithm for a computer-controlled Car. Subclasses should provide a constructor that takes no arguments, so that they an be instantiated using 'Class.forName(...).newInstance()'. */
public abstract class Drone {
  /** Constructs a new Drone. All subclasses should provide a constructor that takes no arguments. */
  public Drone() {}
  
  /* New API. */
  
  /** Called at the start of each race.
   * @param land the Landscape on which the race will take place.
   * @param car provides all sorts of information about the Car, including its initial position and orientation.
   */
  public abstract void reset(Landscape land, Car car);
  
  /** Called every millisecond. The method should compute and return a bitmask indicating which keys the computer player is pressing, as follows:<ul>
   * <li>Bit 0 set indicates that the 'left' key is pressed.
   * <li>Bit 1 set indicates that the 'right' key is pressed.
   * <li>Bit 2 set indicates that the 'accelerate' key is pressed.
   * <li>Bit 3 set indicates that the 'brake' key is pressed.
   * <li>Bit 4 set indicates that the 'change gear' key is pressed.
   * </ul>Setting bits 0, 1 and 3 together activates the panic button.
   * @param car the latest state of the Car. Note that there is no guarantee that the same Car object will be passed each millisecond.
   * @return a bitmask indicating which keys are pressed.
   */
  public abstract int tick(Car car);
}
