package org.sc3d.apt.jrider.v1;

/** One of the argument types of the constructor of NetworkController. This interface must be implemented by classes which are interested in being informed of extended messages received from a network game server. Extended messages are used to configure the players and to distribute chat messages and so on. Extended messages are not used for ordinary keyboard events, which are handled at a lower level by the NetworkController itself.
 * <p>The possible range of extended messages is described in a separate document 'protocol.h', which is authoritative if it differs from the information provided here for your convenience. NetworkListeners must understand almost all types of message to simulate the game correctly. The possible types include:<ul>
 * <li>type 0 (sc_chat_message), a chat message. The payload is a UTF-8 string. These messages may be ignored but should be displayed to the user; they may be used by the server to indicate general game information.
 * <li>type 1 (sc_track_info), info about a track. The first byte of the payload gives the number of players currently on the track, and the rest is a UTF-8 string giving the name of the track. These messages may be ignored.
 * <li>type 2 (sc_assign_player), server has allocated us a player number. The payload is a single byte, giving a player number from '0' to '5'. What we do with this player number is our own business. We keep it until we disconnect. Best not to ignore these messages, as we need player numbers.
 * <li>type 3 (sc_game_full), the game is full (there are no more free player numbers). You may play on with the players you've got, or abort.
 * <li>type 4 (sc_car_parameters), which is sent from the server to the client whenever a player joins the track. The payload consists of at least two bytes. The first byte is a player number (as allocated by the server) from '0' to '5'. The second byte describes the player configuration, as follows: the top bit indicates that the front wheels are driven; the next bit indicates that the back wheels are driven; the bottom six bits give the colour number for the car, currently from '0' to '5'. The remaining bytes form a UTF-8 string giving the player's name.
 * <li>type 5 (sc_time_step), the server has decided to change the frequency with which it sends new key data. The payload consists of a two-byte number (most significant byte first) giving the number of milliseconds of game time represented by each word of key data. The new rate applies with immediate effect.
 * <li>type 6 (sc_player_leaves), which is sent from the server to the client whenever a player leaves the game. The payload consists of one byte: the player number from '0' to '5'.
 * </ul>Changes in the membership of the game or car parameters do not take effect until the next time 'escape' is pressed. You should expect any type of message at any time. The state of the game just after you connect could be thoroughly confused, but everything will become defined when somebody presses 'escape'.
 */
public interface NetworkListener {
  /** Called by 'NetworkController.getKeyData()' when it finds an extended message in the data received from the server. This method should return as quickly as possible.
   * @param type one of the sc_message_type values.
   * @param payload an array of bytes giving the payload received from the server. The length of the array is the length received from the server.
   */
  public void processExtendedMessage(int type, byte[] payload);
}
