package org.sc3d.apt.jrider.v1;

/** Represents the properties of a car. Instances are immutable. */
public class PlayerConfig {
  /** Constructs a PlayerConfig given values for its fields. */
  public PlayerConfig(
    boolean fwd, boolean bwd,
    int colour, String name
  ) {
    this.fwd = fwd; this.bwd = bwd;
    this.colour = colour; this.name = name;
  }
  
  /* New API. */
  
  /** 'true' if the engine drives the front wheels of the car (i.e. for front-wheel-drive or four-wheel-drive). */
  public final boolean fwd;

  /** 'true' if the engine drives the back wheels of the car (i.e. for back-wheel-drive or four-wheel-drive). */
  public final boolean bwd;
  
  /** The colour of the car, from '0' to '5'. */
  public final int colour;
  
  /** The name of the player. */
  public final String name;
}
