/*
 * game.h:
 * Objects representing games.
 *
 * Copyright (c) 2003 Chris Lightfoot. All rights reserved.
 * Email: chris@ex-parrot.com; WWW: http://www.ex-parrot.com/~chris/
 *
 * $Id: game.h,v 1.2 2003/10/19 01:33:03 chris Exp $
 *
 */

#ifndef __GAME_H_ /* include guard */
#define __GAME_H_

#include "peer.h"

typedef struct game *game;

/* game.c */
game game_new(const char *track, const uint16_t timestep);
void game_delete(game g);
int game_add_player(game g, peer p);
void game_pre_select(game g, int *n, fd_set *rd, fd_set *wr, fd_set *ex, struct timeval *tv);
int broadcast_key_states(game g);
int game_post_select(game g, fd_set *rd, fd_set *wr, fd_set *ex);
int game_send_info(game g, peer p);
char *game_trackname(game g);

#endif /* __GAME_H_ */
