package org.sc3d.apt.jrider.v1;

/** Represents the state of a 'Frames Per Second' counter. */
public class FPSCounter {
  /** Contructs a FPSCounter. */
  public FPSCounter() { this.totTime = 0; this.count = 0; }
  
  /* New API. */
  
  /** Call this method once for each frame of each running animation. Every so often, it will print to 'System.out' an estimate of the number of frames per second.
   * @param time the time in milliseconds since the last call (it is the caller's responsibility to do the actual timing).
   * @param num the number of animations running.
   */
  public void doFrame(int time, int num) {
    this.totTime += time;
    if (++this.count<1000) return;
    final float fps = (float)(1000000.0/this.totTime);
    System.out.println("fps: "+fps+" ("+fps/num+" each)");
    this.totTime = 0; this.count = 0;
  }
  
  /* Private. */
  
  private int totTime, count;
}
