package org.sc3d.apt.jrider.v1;

/** Collects all the information needed to draw a single frame. */
public class Frame {
  /** Constructs a new Frame. Initially, there are no Faces (i.e. the 'faces' field is null).
   * @param land a Landscape to draw before all the objects and shadows.
   * @param camera the viewpoint and direction.
   * @param lens the size and magnification.
   */
  public Frame(Landscape land, Camera camera, Lens lens) {
    this.land = land; this.camera = camera; this.lens = lens;
    this.faces = null;
  }
  
  /** The value passed to the constructor. */
  public final Landscape land;
  public final Camera camera;
  public final Lens lens;
  
  /** A queue of Faces, representing the paint, shadows and objects that will be drawn on the Landscape. */
  public Face faces;
}
