package org.sc3d.apt.jrider.v1;

/** A random number generator that can produce signed or unsigned integers, and which is seeded by a String so that the seeds are more memorable. The sequence of numbers depends only on the alpha-numeric characters in the string, and is case-insensitive, so 'alistair turnbull!' and 'AlistairTurnbull' are equivalent (US-ASCII is assumed).
 * <p>The implementation of this class is quite similar to that of 'java.util.Random' but does not depend on it.
 */
public class Random {
  /** Constructs a new Random given a seed. */
  public Random(String seed) {
    this.seed = 182756827;
    for (int i=0; i<seed.length(); i++) {
      final char c = seed.charAt(i);
      if (c>='0' && c<='9') {
        this.seed = this.seed*398465313 + (c-'0');
      } else if (c>='A' && c<='Z') {
        this.seed = this.seed*986259231 + (c-'A');
      } else if (c>='a' && c<='z') {
        this.seed = this.seed*986259231 + (c-'a');
      }
    }
    this.seed |= 1;
  }
  
  /* New API. */
  
  /** Generates an integer. */
  public int nextInt() {
    this.seed *= 842756985;
    return (int)(this.seed>>32);
  }
  
  /** Generates an integer in the range '0' to 'n-1'. */
  public int nextUInt(int n) {
    this.seed *= 842756985;
    return (int)(((this.seed>>>32)*n)>>>32);
  }
  
  /** Generates an integer in the range '-n/2' to 'n/2-1'. */
  public int nextSInt(int n) {
    this.seed *= 842756985;
    return (int)(((this.seed>>32)*n)>>32);
  }
  
  /* Private. */
  
  private long seed;
}
