package org.sc3d.apt.jrider.v1;

import java.awt.image.*;

/** An experiment to find out whether I should be using a BufferedImage instead of an ImageProducer. Eventually I decided I should, and it made almost no difference. Sucks to be me. */
public class Test {
  /** Displays an animation using a BufferedImage. */
  public static void main(String[] args) {
    // Make ourselves a BufferedImage.
    final byte[] pixels = new byte[256*256];
    for (int y=0; y<256; y++) for (int x=0; x<256; x++)
      pixels[x+256*y] = (byte)(x^y);
    final DataBuffer db = new DataBufferByte(pixels, pixels.length);
    final SampleModel sm = new PixelInterleavedSampleModel(
      db.getDataType(), // This will be 'DataBuffer.TYPE_BYTE'.
      256, 256,
      1, 256, new int[] {0}
    );
    final WritableRaster wr = Raster.createWritableRaster(sm, db, null);
    final byte[] cr = new byte[256], cg = new byte[256], cb = new byte[256];
    for (int i=0; i<256; i++) {
      cr[i] = (byte)(17*(3&i) + 68*(3&(i>>6)));
      cg[i] = (byte)(17*(3&i) + 68*(3&(i>>4)));
      cb[i] = (byte)(17*(3&i) + 68*(3&(i>>2)));
    }
    final IndexColorModel icm = new IndexColorModel(8, 256, cr, cg, cb);
    final BufferedImage bi = new BufferedImage(icm, wr, true, null);
    // Open a window.
    final java.awt.Canvas canvas = new java.awt.Canvas();
    canvas.setSize(512, 512);
    final java.awt.Frame frame = new java.awt.Frame("Test");
    frame.add(canvas);
    frame.pack();
    frame.setVisible(true);
    // Animation loop.
    long lastTime = System.currentTimeMillis();
    int count = 0;
    while (true) {
      for (int y=0; y<256; y++) for (int x=0; x<256; x++)
        pixels[x+256*y] = (byte)((x^y) + count);
      canvas.getGraphics().drawImage(
        bi,
        0, 0, 512, 512,
        canvas.getBackground(),
        null
      );
      if (++count==256) {
        long time = System.currentTimeMillis();
        System.out.println(256000.0/(time-lastTime)+"fps");
        lastTime = time;
        count = 0;
      }
    }
  }
}
